//
//  MCPObjectDeletionHandler.h
//  MCFoundation
//
//  Created by Ali Lalani on 02/11/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "MCFoundationDefines.h"
#import "MCPObjectContext.h"
#import "MCPObject.h"
#import "MCPUserProtocol.h"

@interface MCPObjectDeletionHandler : NSObject {
	MCPObjectContext *__context;

	id <MCPUserProtocol> __user;

	BOOL __inBulkMode;
}
- (id)initWithObjectContext:(MCPObjectContext *)oc user:(id <MCPUserProtocol>)aUser;

/*!
@method canDeleteModelObject:
@discussion checks to see if aModel can be deleted. Deletion permission is denied if the user does not have delete permission (according the permission sentry), it's a contact and that contact is a user, cannot lock the object.
*/
- (BOOL)canDeleteModelObject:(id)aModel error:(NSError **)error; // includes an NSError to explain why it could not be deleted
- (BOOL)canDeleteModelObject:(id)aModel;
- (BOOL)canDeleteModelObjects:(NSArray *)objs error:(NSError **)error;

/*!
@method deleteModelObject:
@discussion checks to see if the model can be deleted, if so, tells the editing context to do so and returns whether it was allowed to delete the object or not.
@param aModel - the MCPObject subclass to delete
*/
- (BOOL)deleteModelObject:(id)aModel error:(NSError **)error; // includes an explanation of why it could not be deleted if applicable
- (BOOL)deleteModelObject:(id)aModel;

/*!
@method deleteModelObjects:
@discussion checks each object whether it can be deleted or not, if so, add it to an array and returns that array. It is entirely possible that the number of objects passed in will be different than what is returned. See canDeleteModelObject: for more details. This method also ensures that we are in bulk mode.
@param objs - an array of objects that are a subclass of MCPObject
*/
- (NSArray *)deleteModelObjects:(NSArray *)objs;

#pragma mark Accessors
- (MCPObjectContext *)objectContext;
- (id <MCPUserProtocol>)user;
@end
